/*
 * Copyright (C) 2014 Yahoo Inc.
 */

/**
 * An object which watches for user input on subject line and notifies the native code
 */
var subjectTextController = {
    subjectContainerNode: null,
    subjectInputNode: null,

    /**
     * A method which starts the subjectTextController
     */
    init: function(subjectContainerNode, subjectInputNode) {
        this.subjectContainerNode = subjectContainerNode;
        this.subjectInputNode = subjectInputNode;

        this.subjectContainerNode.addEventListener("click", this.handleSubjectRowClick.bind(this), false);
        this.subjectInputNode.addEventListener("input", this.inputTextWatcher.bind(this), false);
    },

    /**
     * This method is notified of every change the user makes to the subject input field
     */
    inputTextWatcher: function(event) {
        yMailBridge.updateTitle(event.srcElement.value);
    },

    /**
     * This method is invoked to set the subject to some value
     */
    setSubject: function(subject) {
        this.subjectInputNode.value = subject;
    },

    /**
     * Handles click events on the entire recipient row and focuses the correct elements inside the row
     */
    handleSubjectRowClick: function(event) {
        this.subjectInputNode.focus();
    }
};
